﻿var outgoingSMS = {
    datatable: null,
    refreshDataTable: function () {
        outgoingSMS.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-outgoingSMSTable").a4datatable({            
            ajaxAction: a4.getAction("GetOutgoingSMSConfigurations", "Distributions", "Admin"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Class": "id" },
                { "Name": "Client", "Title": resources.Customer, "Data": "Client" },
                { "Name": "Number", "Title": resources.ProviderNumber, "Data": "Number" },
                { "Name": "Name", "Title": resources.Name, "Data": "Name" },
                { "Name": "Account", "Title": resources.Provider, "Data": "AccountType" },
                { "Name": "AuthId", "Title": resources.AuthId, "Data": "AuthId" },
                { "Name": "AuthToken", "Title": resources.Token, "Data": "AuthToken" },
                { "Name": "Active", "Title": resources.Active, "Data": "Active", "Label": "ActiveLabel" },
                { "Name": "LastConnectionStatus", "Title": resources.LastConnectionStatus, "Data": "LastConnectionStatusDisplay" },
                { "Name": "LastConnectionDate", "Title": resources.LastConnectionDate, "Data": "LastConnectionDate" }
            ],
            defaultSorting: "Number",
            allowRowSelection: true,
            toolBarItems: [{ "Action": "delete", "Label": resources.Delete }],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                if (action == "delete") {
                    outgoingSMS.deleteItems(ids);
                }
            },
            contextMenuItems: [
                { "Action": "test", "Label": resources.TestConnection },
                { "Divider": true },
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "edit", "Label": resources.Properties }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "edit":
                        modalDialog.showWindow(a4.getAction("OutgoingSMSEditor", "Distributions", "Admin", { id: row.Id }), 650, 650, { afterClose: function () { outgoingSMS.refreshDataTable(); } });
                        break;

                    case "delete":
                        outgoingSMS.deleteItems(row.Id);
                        break;

                    case "test":
                        outgoingSMS.testItem(row.Id, null, null, null, null, null, null, 1, null);
                        break;
                }
            }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addOutgoingSMS", function () {
            modalDialog.showWindow(a4.getAction("OutgoingSMSEditor", "Distributions", "Admin"), 650, 650);
        });
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteConfigurationsResources, function () {
            a4.callServerMethod(a4.getAction("DeleteOutgoingSMS", "Distributions", "Admin"), { itemIds: items },
                function (result) {
                    outgoingSMS.refreshDataTable();
                });
        }, 250, 400, true, { "count": itemsCount });
    },
    testItem: function (id, fromPhone, toPhone, name, authId, authToken, accountType, testConnectionType, clientId) {
        a4.callServerMethod(a4.getAction("TestOutgoingSMSConnection", "Distributions", "Admin"), { id: id, fromPhone: fromPhone, toPhone: toPhone, name: name, authId: authId, authToken: authToken, accountType: accountType, testConnectionType: testConnectionType, clientId: clientId },
            function (result) {
                if (result.success) {
                    a4.showSuccessMessage(result.message);
                }
                else if (result.action) {
                    modalDialog.showWindow(a4.getAction("OutgoingSMSEditor", "Distributions", "Admin", { id: id }), 650, 650, { afterClose: function () { outgoingSMS.refreshDataTable(); } });
                }
                else {
                    a4.showErrorMessage(result.message);
                }

                if (id > 0 && !result.action)
                    outgoingSMS.refreshDataTable();
            });
    }
}

$(document).ready(function () {
    if ($(".v-outgoingSMSTable").length > 0) {
        outgoingSMS.initializeDataTable();
        outgoingSMS.bindEvents();
    }
});